<?php
header('Content-Type: application/json');
$dbFile = 'ayurkavach_final.sqlite';

try {
    $pdo = new PDO("sqlite:" . $dbFile);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Database Table
    $pdo->exec("CREATE TABLE IF NOT EXISTS orders (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        name TEXT, email TEXT, phone TEXT, address TEXT,
        details TEXT, total REAL, created_at DATETIME DEFAULT CURRENT_TIMESTAMP
    )");

    $input = json_decode(file_get_contents('php://input'), true);

    if ($input) {
        $customer = $input['customer'];
        $items = $input['items'];
        $grandTotal = $input['total'];

        $summary = "";
        foreach ($items as $item) {
            $summary .= "{$item['title']} ({$item['weight']} x{$item['qty']}) - ₹" . ($item['unitPrice'] * $item['qty']) . "\n";
        }

        // 1. Save to SQLite
        $stmt = $pdo->prepare("INSERT INTO orders (name, email, phone, address, details, total) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->execute([$customer['name'], $customer['email'], $customer['phone'], $customer['address'], $summary, $grandTotal]);

        // 2. Send Email
        //sendConfirmationEmail($customer, $summary, $grandTotal);

        echo json_encode(['status' => 'success']);
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}

/**
 * Function to send email
 */
function sendConfirmationEmail($customer, $summary, $total) {
    $to = $customer['email'];
    $subject = "Order Confirmation - Ayurkavach";
    
    $message = "Hello " . $customer['name'] . ",\n\n";
    $message .= "Thank you for your order! We have received your request for Cash on Delivery.\n\n";
    $message .= "Order Details:\n" . $summary . "\n";
    $message .= "Grand Total: ₹" . $total . "\n\n";
    $message .= "Delivery Address:\n" . $customer['address'] . "\n\n";
    $message .= "We will contact you on " . $customer['phone'] . " soon.\n\n";
    $message .= "Stay Healthy,\nTeam Ayurkavach";

    $headers = "From: no-reply@ayurkavach.com\r\n" .
               "Reply-To: support@ayurkavach.com\r\n" .
               "X-Mailer: PHP/" . phpversion();

    // Standard PHP mail function (works on most shared hosting)
    @mail($to, $subject, $message, $headers);
    
    // Also send a notification to the admin
    @mail("admin@ayurkavach.com", "New Order Received - " . $customer['name'], $message, $headers);
}
?>