<?php
header('Content-Type: application/json');
$database = 'ayurkavach_v2.sqlite';

try {
    $pdo = new PDO("sqlite:" . $database);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Dynamic table creation
    $pdo->exec("CREATE TABLE IF NOT EXISTS customer_orders (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        customer_name TEXT,
        mobile_number TEXT,
        shipping_address TEXT,
        ordered_items TEXT,
        order_total REAL,
        order_date DATETIME DEFAULT CURRENT_TIMESTAMP
    )");

    $data = json_decode(file_get_contents('php://input'), true);

    if ($data) {
        $summary = "";
        foreach ($data['items'] as $item) {
            $summary .= $item['title'] . " (Pack:" . $item['packSize'] . "); ";
        }

        $sql = "INSERT INTO customer_orders (customer_name, mobile_number, shipping_address, ordered_items, order_total) 
                VALUES (?, ?, ?, ?, ?)";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $data['customer']['name'],
            $data['customer']['mobile'],
            $data['customer']['address'],
            $summary,
            $data['total']
        ]);

        echo json_encode(['status' => 'success']);
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>