<?php
header('Content-Type: application/json');

// 1. Database Configuration
$dbFile = 'ayur_orders_prod.sqlite';

try {
    $pdo = new PDO("sqlite:" . $dbFile);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Create the persistent table
    $pdo->exec("CREATE TABLE IF NOT EXISTS customer_orders (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        name TEXT, 
        email TEXT, 
        phone TEXT, 
        address TEXT, 
        summary TEXT, 
        total REAL, 
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP
    )");

    $payload = json_decode(file_get_contents('php://input'), true);

    if ($payload) {
        $customer = $payload['customer'];
        $items = $payload['items'];
        $grandTotal = $payload['total'];

        $itemSummary = "";
        foreach ($items as $item) {
            $itemSummary .= "{$item['title']} ({$item['weight']} x{$item['qty']}) - ₹" . ($item['unitPrice'] * $item['qty']) . "\n";
        }

        // Save to SQLite
        $stmt = $pdo->prepare("INSERT INTO customer_orders (name, email, phone, address, summary, total) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->execute([
            $customer['name'], 
            $customer['email'], 
            $customer['phone'], 
            $customer['address'], 
            $itemSummary, 
            $grandTotal
        ]);

        // Trigger Email Notification
        $to = $customer['email'];
        $subject = "Confirming Your Ayurkavach Superfood Order";
        $headers = "From: Ayurkavach <no-reply@ayurkavach.com>\r\n" .
                   "Content-Type: text/plain; charset=UTF-8";
        
        $body = "Hi " . $customer['name'] . ",\n\n" .
                "Your order has been received! Here is a summary:\n\n" .
                $itemSummary . "\n" .
                "Total Amount: ₹" . $grandTotal . "\n\n" .
                "We are preparing your shield for delivery to:\n" .
                $customer['address'] . "\n\n" .
                "Stay Healthy,\nTeam Ayurkavach";
/*
        @mail($to, $subject, $body, $headers); // Mail to User
        @mail("admin@ayurkavach.com", "NEW ORDER: " . $customer['name'], $body, $headers); // Mail to Admin
        
        */

        echo json_encode(['status' => 'success']);
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>